//--------------------------------------------------------------------------------------
// File: VisLU1CS.fx
//
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
float appTime;					//App's time in seconds
float4x4 worldMatrix;			// World matrix for object
float4x4 worldViewProjection;	// World * View * Projection matrix

texture volumetex;				// Textur

// Struktur fr VertexShader-Input
struct VS_INPUT 
{
   float3 Position : POSITION0;
   float3 Texcoord : TEXCOORD0;   
};

// Struktur fr VertexShader-Output
struct VS_OUTPUT 
{
   float4 Position : POSITION0;
   float3 Texcoord : TEXCOORD0;
};

VS_OUTPUT vs_main( VS_INPUT Input )
{
   VS_OUTPUT Output;   
   float4 temp = mul( float4(Input.Position,1), worldMatrix );
   Output.Position = mul( temp, worldViewProjection );
   Output.Texcoord = Input.Texcoord;       
   return( Output );   
}

sampler3D baseMap = sampler_state{
	Texture = <volumetex>;
	MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct PS_INPUT 
{
   float3 Texcoord : TEXCOORD0; 
};

float4 ps_main( PS_INPUT Input ) : COLOR0
{
   return tex3D( baseMap, Input.Texcoord );   
}

float3 expand(float3 v){	
	return (v - 0.5f) * 2.0f;	
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------
technique RenderScene
{
    pass P0
    {          
    }
}

technique RenderVolume
{
    pass P0
    {   
        VertexShader = compile vs_1_1 vs_main();
        PixelShader  = compile ps_1_1 ps_main();       
    }
    
}


